<?php
// Include the database configuration file
include 'config.php';

// Check if the form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Sanitize and validate input
    $username = isset($_POST['username']) ? htmlspecialchars($_POST['username']) : '';
    $id = isset($_POST['id']) ? htmlspecialchars($_POST['id']) : '';
    $password = isset($_POST['password']) ? htmlspecialchars($_POST['password']) : '';
    $email = isset($_POST['email']) ? htmlspecialchars($_POST['email']) : '';
    $contact_number = isset($_POST['contact_number']) ? htmlspecialchars($_POST['contact_number']) : '';
    $full_name = isset($_POST['full_name']) ? htmlspecialchars($_POST['full_name']) : '';
    $mt5username = isset($_POST['mt5username']) ? htmlspecialchars($_POST['mt5username']) : '';
    $status = isset($_POST['status']) ? htmlspecialchars($_POST['status']) : '1'; // Default status to 1

    // Prepare and execute the SQL query
    try {
        $sql = "INSERT INTO users (username, id, password, email, contact_number, full_name, mt5username, status) 
                VALUES (:username, :id, :password, :email, :contact_number, :full_name, :mt5username, :status)";

        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':username', $username);
        $stmt->bindParam(':id', $id);
        $stmt->bindParam(':password', password_hash($password, PASSWORD_DEFAULT)); // Hash the password
        $stmt->bindParam(':email', $email);
        $stmt->bindParam(':contact_number', $contact_number);
        $stmt->bindParam(':full_name', $full_name);
        $stmt->bindParam(':mt5username', $mt5username);
        $stmt->bindParam(':status', $status);

        // Execute the query
        if ($stmt->execute()) {
            echo 'User added successfully.';
        } else {
            echo 'Error adding record: ' . $stmt->errorInfo()[2];
        }
    } catch (PDOException $e) {
        echo 'Database error: ' . $e->getMessage();
    }
} else {
    echo 'Invalid request method.';
}
?>
